### 实验名称

基于Nginx的Web服务OpenResty平台，来实现Redis的Key-Value数据存储应用于页面缓存的功能。

### 实验目的

1、掌握 Redis Key-Value存储服务的使用；

2、掌握 对Redis数据存储服务的Lua编程应用；

3、掌握 Redis的高性能存储服务在Nginx代理服务多级缓存的应用。

### 实验背景

Redis是一个Key-Value存储服务，是一个开源的使用ANSI C语言编写、支持网络、可基于内存亦可持久化的日志型、Key-Value数据库，并提供多种语言的API。常用的应用场景包括：Key-Value数据存储、会话缓存、页面缓存、消息队列平台、技术排序等。本实验将基于Nginx的Web服务OpenResty平台，来实现Redis的Key-Value数据存储应用于页面缓存的功能。

### 实验原理

OpenResty（又称：ngx\_openresty）是一个基于 Nginx 的可伸缩的 Web 平台，它是一个强大的 Web 应用服务器，更主要的是在性能方面，OpenResty可以 快速构造出足以胜任 10K 以上并发连接响应的超高性能。多级缓存就是其高性能的特征之一。使用Redis来实现在Nginx代理服务器上的页面内容的载入缓存与缓存读取的是典型的多级缓存解决方案。

方案如下图所示：需要在页面上显示页面的新闻信息，并能实现Ngingx缓存和Redis缓存的多级缓存机制。

![image_course_1653_user_3165_assignment_17726_1694063887485.png](./pic/image_course_1653_user_3165_assignment_17726_1694063887485.png)

1.  首先访问Nginx ，我们可以采用缓存的方式，先从Nginx本地缓存中获取，获取后直接响应；
2.  如果没有获取到，再次访问Redis，我们可以从Redis中获取数据，如果有则返回，并缓存到Nginx中；
3.  如果没有获取到，再次访问MySQL，我们从MySQL中获取数据，再将数据存储到Redis中，返回。

### 实验环境

Ubuntu18.04

Redis 7.0.12

OpenResty 1.21.4.2

MySQL 5.7.28

### 建议课时

4课时

### 实验步骤

一、实验准备

1、启动 Redis 服务

```markup
redis-server

```

2、打开另一终端terminal：首先，OpenResty 依赖库有： perl 5.6.1+， libreadline，libpcre，libssl。所以我们需要先安装好这些依赖库，安装操作如下：

```python
sudo apt-get update
```

```python
sudo apt-get install libreadline-dev libpcre3-dev libssl-dev perl
```

接下，下载最新的 OpenResty 源码包并解压编译安装:

```python
sudo wget http://10.90.3.2/BDColl/Nosql/openresty-1.21.4.2.tar.gz

```

```python
sudo tar xzvf openresty-1.21.4.2.tar.gz
```

```python
cd openresty-1.21.4.2/ 
sudo ./configure
```

```python
sudo make
```

```python
sudo make install
```

默认情况下程序会被安装到 /usr/local/openresty 目录，可以使用  ./configure --help 查看更多的配置选项。

安装成功后，我们就可以使用 OpenResty 直接输出 html 页面来验证是否正常工作。

首先我们可以创建一个工作目录：

```python
sudo mkdir /home/www

```

```python
cd /home/www/
sudo mkdir logs/ conf/
```

中 logs 目录用于存放日志，conf 用于存放配置文件。

接着，我们在 conf 目录下创建一个 nginx.conf 文件，

```python
sudo vi conf/nginx.conf
```

代码如下：

```markup
worker_processes  1;
error_log logs/error.log;
events {
    worker_connections 1024;
}
http {
    server {
        listen 9000;
        location / {
            default_type text/html;
            content_by_lua '
                ngx.say("<p>Hello, World!</p>")
            ';
        }
    }
}
```

下面，验证 OpenResty工作是否正常。默认情况下 OpenResty安装在 /usr/local/openresty 目录中，启动命令为:

```python
cd /home/www
sudo /usr/local/openresty/nginx/sbin/nginx -p `pwd`/ -c conf/nginx.conf
```

如果没有任何输出，说明启动成功，\-p 指定我们的项目目录，\-c 指定配置文件。

接下来我们可以使用 curl 来测试是否能够正常范围：

```markup
sudo curl http://localhost:9000/
```

输出结果为：

<p>Hello, World!</p>

3、在后台MySQL数据库里创建Web server的原始资源数据

登陆MySQL，root账户密码：123456。

```python
sudo mysql -u root -p
```

数据库里创建资源数据库及创建表，写入原始资源数据：

```java
CREATE DATABASE `redisCache`;
USE `redisCache`;

/* Table structure for table `tb_content` */

DROP TABLE IF EXISTS `tb_content`;

CREATE TABLE `tb_content` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `category_id` bigint(20) NOT NULL COMMENT '内容类目ID',
  `title` varchar(200) DEFAULT NULL COMMENT '内容标题',
  `msg` varchar(500) DEFAULT NULL COMMENT '链接',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `category_id` (`category_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

/* Data for the table `tb_content` */

insert  into `tb_content`(`id`,`category_id`,`title`,`msg`) values 
(28,1,'JingDong',' 8月1日又传出要收购控股永辉超市(601933)的消息。 对此,京东回应称,目前没有这个意向。'),
(29,1,'BigLottery',' 1月10日,体彩大乐透第22005期开奖,当期全国中出16注一等奖,单注奖金627万元。'),
(30,2,'Charity',' 中华慈善总会向社会各界发出倡议，希望全体爱心力量充分发扬中华民族“出入相友、守望相助”的优良传统，为受灾地区群众提供慈善援助，为受灾地区抗洪救灾及灾后重建工作提供有力支持！'),
(31,2,'CNBA',' 2023年02月20日，广西威壮卫冕2022全国男子篮球联赛总冠军');

```

设置MySQL本地登陆权限(密码：123456)：

```python
sudo mysql -h 127.0.0.1 -u root -p
```

然后在MySQL里执行：

```python
grant all on *.* to 'root'@'%';
```

然后重启MySQL：

```python
sudo service mysql restart
```

二、Redis缓存实现

1、创建Lua脚本实现资源文件缓存入Redis数据库：

创建Lua脚本 ：

```python
sudo mkdir /root/lua
sudo mkdir /root/lua/68
sudo vi /root/lua/68/update_content.lua
```

代码如下（注意MySQL和Redis的地址和用户名密码等信息要根据实际配置做相应修改。）：

```python
ngx.header.content_type="application/json;charset=utf8"
local cjson = require("cjson")
local mysql = require("resty.mysql")
-- 获取用户请求的参数 (请求url链接的"?"后的参数)
local uri_args = ngx.req.get_uri_args()
-- 请求参数里的"id"参数的值
local id = uri_args["id"]

-- 连接mysql数据库
local db = mysql:new()
db:set_timeout(1000)
-- 连接信息，host，port，database，user，password
local props = {
host = "127.0.0.1",
port = 3306,
database = "redisCache",
user = "root",
password = "123456"
}
-- 获取数据库连接
local res = db:connect(props)
-- sql语句
local select_sql = "SELECT title, msg FROM tb_content WHERE category_id ="..id.." "
-- 执行查询语句
res = db:query(select_sql)
-- 关闭数据库
db:close()

-- redis
local redis = require("resty.redis")
local red = redis:new()
red:set_timeout(2000)
-- redis的ip地址及端口
local ip ="127.0.0.1"
local port = 6379
red:connect(ip,port)
-- redis密码，如果没有就直接注释掉
-- red:auth("root")

--调用API获取数据
local resp, err = red:get("hello")
if not resp then
    ngx.say("get msg error : ", err)
    return close_redis(red)
end  
-- 存储,key="content_1",value=res的json类型,(res为mysql数据库里查询出的数据）
red:set("content_"..id,cjson.encode(res))
red:close()

-- 输出true
ngx.say("<p>Redis Caching succeeded! Please check in Redis.</p>")

```

2、修改Nginx配置文件

将配置文件使用的根设置为root，目的就是将来要使用Lua脚本的时候 ，直接可以加载在root下的Lua脚本。

然后配置nginx的server，拦截update\_content?id=1请求路径,交给Lua脚本处理：

```python
sudo vi /usr/local/openresty/nginx/conf/nginx.conf
```

代码如下：

```python
# user  nobody;
user root root;
worker_processes  1;

# error_log  logs/error.log  info;
# pid   logs/nginx.pid;

events {
    worker_connections  1024;
}

http {
    include       mime.types;
    default_type  application/octet-stream;

    # log_format  main  '$remote_addr - $remote_user [$time_local] "$request" '
    # '$status $body_bytes_sent "$http_referer" '
    # '"$http_user_agent" "$http_x_forwarded_for"';

    # access_log  logs/access.log  main;

    # cache
    lua_shared_dict dis_cache 128m;

    sendfile        on;
    #tcp_nopush     on;

    # keepalive_timeout  0;
    keepalive_timeout  65;

    # gzip  on;

    server {
        listen       80;
        server_name  localhost;

        # 将用户请求update?id=1转到update_content.lua脚本处理
        location /update {
                content_by_lua_file /root/lua/68/update_content.lua;
    	}
    }
}

```

修改完配置文件后，重启Nginx：

```python
# 进入nginx的sbin文件夹 /usr/local/openresty/nginx/sbin
cd /usr/local/openresty/nginx/sbin
# 重启nginx
sudo pkill -9 nginx
sudo ./nginx -c conf/nginx.conf 
sudo ./nginx -s reload

```

3、验证数据缓存入Redis的结果

浏览器访问：

```markup
http://127.0.0.1/update?id=1
```

浏览器页面(打开“Developer tools”功能)如图所示：

![image_course_1653_user_3165_assignment_17726_1698391515526.png](./pic/image_course_1653_user_3165_assignment_17726_1698391515526.png)

配置正确的话，就会从数据库查询然后在redis中看到出现key="content\_1"的键值对，如图所示：

![image_course_1653_user_3165_assignment_17726_1698391624298.png](./pic/image_course_1653_user_3165_assignment_17726_1698391624298.png)

到这儿，我们已经成功的完成了数据缓存入Redis数据库了。接着，我们将进一步实现浏览同一url时能够从Reids缓存里读取内容，实现高速缓存的目的。

4、读取Redis缓存的Lua脚本实现

缓存的意义就在于在用户请求的页面资源能首先从缓存里读取，从而提高性能和减少服务器端的负载压力。接下来我们实现从Redis里读取缓存的内容。

新建脚本：

```python
sudo vi /root/lua/68/ad_read.lua
```

代码如下：

```python
ngx.header.content_type="application/json;charset=utf8"
-- 获取请求中的参数ID
local uri_args = ngx.req.get_uri_args();
local position = uri_args["id"];

-- 获取nginx本地缓存dis_cache
local cache_ngx = ngx.shared.dis_cache;
-- 根据ID 获取Nginx本地缓存数据
local adCache = cache_ngx:get('ad_cache_'..position);

if adCache == "" or adCache == nil then
       	    -- 引入redis库
        local redis = require("resty.redis");
        -- 创建redis对象
        local red = redis:new()
        -- 设置超时时间
        red:set_timeout(2000)
        -- 连接
        local ok, err = red:connect("127.0.0.1", 6379)
        -- 获取key的值
        red:auth("root")
        local res_content=red:get("content_"..position)
        -- 输出到返回响应中
        ngx.say(res_content)
        -- 关闭连接
        red:close()
        -- 将Redis中获取到的数据存入Nginx本地缓存模块，缓存存活时间为10*60s（即10分钟）
        cache_ngx:set('ad_cache_'..position, res_content, 10*60);

else
 -- Nginx本地缓存中获取到数据直接输出
 ngx.say(adCache)
end

```

5、Nginx配置文件增加读取Redis缓存逻辑

```python
sudo vi /usr/local/openresty/nginx/conf/nginx.conf
```

全文代码如下：

```markup
# user  nobody;
user root root;
worker_processes  1;

# error_log  logs/error.log  info;
# pid        logs/nginx.pid;

events {
    worker_connections  1024;
}

http {
    include       mime.types;
    default_type  application/octet-stream;

    # log_format  main  '$remote_addr - $remote_user [$time_local] "$request" '
    # '$status $body_bytes_sent "$http_referer" '
    # '"$http_user_agent" "$http_x_forwarded_for"';

    # access_log  logs/access.log  main;
    # cache
    lua_shared_dict dis_cache 128m;

    sendfile        on;
    # tcp_nopush     on;
    # keepalive_timeout  0;
    keepalive_timeout  65;
    # gzip  on;

    server {
        listen       80;
        server_name  localhost;

# 将用户请求update?id=1转到update_content.lua脚本处理
        location /update {
                content_by_lua_file /root/lua/68/update_content.lua;
    	}

# 将用户请求read?id=1转到ad_update.lua脚本处理
        location /read {
                content_by_lua_file /root/lua/68/ad_read.lua;
        }
    }
}
```

然后加载该配置文件：

```python
cd /usr/local/openresty/nginx/sbin
```

重新加载Nginx

```python
sudo pkill -9 nginx
sudo ./nginx -c conf/nginx.conf 
sudo ./nginx -s reload
```

6、结果验证

首先访问http://127.0.0.1/update?id=1，将数据加载入Redis。

```markup
http://127.0.0.1/update?id=1
```

然后访问http://127.0.0.1/read?id=1可将Redis缓存中的数据加载入Nginx缓存。

```markup
http://127.0.0.1/read?id=1
```

如图所示：

![image_course_1653_user_3165_assignment_17726_1698391733386.png](./pic/image_course_1653_user_3165_assignment_17726_1698391733386.png)

![image_course_1653_user_3165_assignment_17726_1698465079132.png](./pic/image_course_1653_user_3165_assignment_17726_1698465079132.png)

第一次访问成功后，关闭Redis:

```python
redis-cli shutdown
```

再次访问http://127.0.0.1/read?id=1，我们发现可以看到该页面仍然可以正常访问,而且响应时间已经极大缩短，内容已经是在Nginx缓存里了，这已经完成了的多级缓存效果。如图所示：

![image_course_1653_user_3165_assignment_17726_1698391789811.png](./pic/image_course_1653_user_3165_assignment_17726_1698391789811.png)

![image_course_1653_user_3165_assignment_17726_1698465119545.png](./pic/image_course_1653_user_3165_assignment_17726_1698465119545.png)

从而验证了浏览页面后内容缓存入Redis，然后Nginx把Redis数据保存到自身缓存的多级缓存功能。

### 实验总结

该实验的主要内容是使用Redis来实现在Nginx代理服务器上的页面内容的载入缓存与缓存读取的是典型的多级缓存解决方案。方案首先从Web server的后台MySQL数据库里读取请求的网页信息，然后将其保存在Redis缓存数据库里，并进一步保存在Nginx本地缓存里，从而实现了用户再次请求server内容时，比如需要在页面上显示页面的新闻信息时，能实现依照性能优先级从Ngingx缓存-Redis缓存的多级缓存机制，提高Web server反应性能。