### **实验目的**

1、掌握Neo4j的数据库连接。

2、掌握Neo4j的数据库查询操作。

3、整合问句分类，问句解析，问句查询，实现医疗知识问答。

### **实验背景**

Neo4j是图数据库，采用原生图结构来存储数据。与cypher语言进行数据库操作。本节案例使用的数据为从网络获取的医疗数据，为避免网络原因，不再进行数据采集，提供爬取后的数据。把数据导入到neo4j数据库中，然后进行数据的查询操作。

### **实验原理**

本实验主要通过

使用QuestionClassifier的classify类完成问句分类，返回值为{'args': {'放射性肺炎': \['disease'\]}, 'question\_types': \['disease\_symptom'\]}。

使用QuestionParser类的parser\_main完成Cypher语句解析，返回值为 \["MATCH (m:Disease)-\[r:has\_symptom\]\->(n:Symptom) where m.name = '放射性肺炎' return m.name, r.name, n.name"\]}\]。

在调用AnswerSearch类的search\_main函数，读取数据库获得问句的结果。

### **实验环境**

Ubuntu16.04

Python3

Neo4j3.5

### **建议课时**

4课时

### **实验步骤**

一、导入数据到Neo4j,并开启neo4j

1.安装neo4j库

```markup
pip install py2neo==2020.1.1
pip install pyahocorasick==1.4.0
```

下载数据到本地

```markup
cd ~
wget http://10.90.3.2/BDHTech/07pro/MedicalQA/04/medical.json
wget http://10.90.3.2/BDHTech/07pro/MedicalQA/04/deny.txt
wget http://10.90.3.2/BDHTech/07pro/MedicalQA/04/disease.txt
wget http://10.90.3.2/BDHTech/07pro/MedicalQA/04/symptoms.txt
wget http://10.90.3.2/BDHTech/07pro/MedicalQA/04/qa.db.dump
```

导入数据到neo4j中

在命令行下执行如下命令：

```markup
sudo neo4j start
```

启动完成后，浏览器打开

```markup
localhost:7474
```

提示输入密码，初始密码为neo4j，如下图：

![neo4j初始密码.png](./pic/neo4j初始密码.png)

初始密码输入后，需要修改密码，如下图：

![neo4j修改密码.png](./pic/neo4j修改密码.png)

修改密码完成后，如果可以看到如下图所示，则说明neo4j启动完成

![neo4j启动.png](./pic/neo4j启动.png)

启动修改密码后，关闭neo4j，并关闭浏览器。

```markup
sudo neo4j stop
```

导入数据到neo4j中

```markup
sudo neo4j-admin load --from=./qa.db.dump --database=graph.db --force
```

在命令行下执行如下命令：

```markup
sudo neo4j start
```

启动完成后，浏览器打开

```markup
localhost:7474
```

打开jupyter

```markup
jupyter notebook
```

在打开的浏览器端，新建python3文件

![创建一个py文件.png](./pic/创建一个py文件.png)

二、Python操作Neo4j

1.导入依赖

```python
import os
import ahocorasick
from py2neo import Graph

```

2.创建QuestionClassifier类：

```python
class QuestionClassifier:

    def __init__(self):

        '''加载特征值'''
        # path = os.sep.join(os.path.abspath(__file__).split(os.sep)[:-1]) # 切换目录为当前文件所在目录
        path = "/home/ubuntu" # 切换目录为当前文件所在目录
        print(path)
        print("init project,please wait a mins")
     
        self.disease_wds = [item.strip() for item in open(path+os.sep+'disease.txt', encoding='utf-8') if item.strip()] # 获取疾病实体信息
        self.symptom_wds = [item.strip() for item in open(path+os.sep+'symptoms.txt', encoding='utf-8') if item.strip()] # 获取症状实体信息
        self.region_wds = set(self.disease_wds + self.symptom_wds) # 把疾病和症状实体去重
        '''构造领域atree'''
        self.region_tree = self.build_actree(list(self.region_wds)) # 基于去重后的疾病和症状实体构建actree

        '''构造词对应dict的类型'''
        self.region_dict = self.build_wdtype_dict() # 基于去重后的疾病和症状实体生成实体对应的类型，如 {'蛋白尿': ['symptom']}  {'放射性肺炎': ['disease']}


        '''问句疑问词'''
        self.symptom_qwds = ['症状', '表征', '现象', '症候', '表现', '征兆', '病症'] # 症状的同义词
        self.complication_qwds = ['并发症', '并发', '一起发生', '一并发生', '一起出现', '一并出现', '一同发生', '一同出现', '伴随发生', '伴随', '共现'] # 并发症的同义词

    '''构造atree'''
    def build_actree(self, worllist):
        actree = ahocorasick.Automaton()  # 初始化trie树
        for idx, key in enumerate(worllist):
            actree.add_word(key, (idx, key))  # 向trie树中添加单词
        actree.make_automaton()    # 将trie树转化为Aho-Corasick自动机
        return actree

    '''构造词对应的类型'''

    def build_wdtype_dict(self): #该函数根据7类实体构造 {特征词：特征词对应类型} 词典。
        wd_dict = dict()
        for wd in self.region_wds:
            wd_dict[wd] = []
            if wd in self.disease_wds:
                wd_dict[wd].append('disease')

            if wd in self.symptom_wds:
                wd_dict[wd].append('symptom')
        return wd_dict

    '''问句过滤'''
    # 通过ahocorasick库的iter()函数匹配领域词，将有重复字符串的领域词去除短的，取最长的领域词返回
    # 功能为过滤问句中含有的领域词，返回{问句中的领域词：词所对应的实体类型}。
    def parse_question(self, question):
        question_wds = []
        for i in self.region_tree.iter(question):
            print('parse_question--->',i)
            wd = i[1][1]  # 匹配到的词-乙肝-
            question_wds.append(wd)
        stop_wds = []
        for wd1 in question_wds:
            for wd2 in question_wds:
                if wd1 in wd2 and wd1 != wd2:
                    stop_wds.append(wd1)  #  stop_wds取重复的短的词，如region_wds=['放射性肺炎', '肺炎']，则stop_wds=['肺炎']
        final_wds = [i for i in question_wds if i not in stop_wds] # final_wds取长词
        print("final_wds-->{}".format(final_wds)) # final_wds-->['放射性肺炎']
        # 按照关键词进行遍历，并获取关键词的类型，类型包括disease还是symptom
        final_dict = {i: self.region_dict.get(i) for i in final_wds}
        print("final_dict-->{}".format(final_dict)) # final_dict-->{'放射性肺炎': ['disease']}
        return final_dict

    '''检查问句中是否含有某实体类型内的特征词'''
    def check_words(self, wds, question): 
        for wd in wds:
            if wd in question:
                return True
        return False

    '''疾病分类'''
    def classify(self, question):
        data = {}
        entity_dict = self.parse_question(question)  #获取问句中包含的领域词及其所在领域，并收集问句当中所涉及到的实体类型；
        print("entity_dict:--->",entity_dict) # entity_dict:---> {'放射性肺炎': ['disease']}
        if not entity_dict:  # 如果问句中不包含实体类型，直接返回为空
            return {}                                
        # 获取问句中的所有实体类别
        entity_types = []
        for type_ in entity_dict.values():
            entity_types += type_
        print("entity_types:--->",entity_types) # entity_types:---> ['disease']

        data['args'] = entity_dict
                        
        question_types = [] #  question_types  获取对应sql查找类型的类型

        '''疾病推症状'''
        if self.check_words(self.symptom_qwds, question) and ('disease' in entity_types):
            question_type = 'disease_symptom'
            question_types.append(question_type)

        '''疾病并发症'''
        if self.check_words(self.complication_qwds, question) and ('disease' in entity_types):
            question_type = 'disease_complication'
            question_types.append(question_type)

        '''如果没有匹配问句的类别，但是有疾病信息，则question_types为相关疾病信息disease_intro'''
        if question_types == [] and 'disease' in entity_types:
            question_types = ['disease_intro']

        '''如果没有查到相关查询信息，但是有症状信息，则question_types为相关症状对应的疾病信息symptom_disease'''
        if question_types == [] and 'symptom' in entity_types:
            question_types = ['symptom_disease']

        data['question_types'] = question_types

        print(data) # {'args': {'放射性肺炎': ['disease']}, 'question_types': ['disease_symptom']}
        return data
```

3.创建QuestionParser类，实现问句翻译成Cypher语句：

```python
class QuestionParser:

    '''构建实体节点'''
    # 输入的参数args为{'肺炎': ['disease']}类型的值，其中列表中可以有多个值，表示一个实体即可能对应一个疾病名称，也可以对应一种症状名称。
    def build_entity_dict(self, args):
        entity_dict = {}
        for key, types in args.items():
            for type in types:
                if type not in entity_dict:
                    entity_dict[type] = [key]
                else:
                    entity_dict[type].append(key)
        # print("entity_dict------->",entity_dict) # entity_dict-------> {'disease': ['放射性肺炎']}
        return entity_dict

 
    '''对问句中的每种问题进行处理'''
    def sql_transfer(self, question_type, entities):
        print("QuestionParser.sql_transfer的参数question_type--->",question_type) # QuestionParser.sql_transfer的参数question_type---> disease_symptom
        print("QuestionParser.sql_transfer的参数entities--->",entities) # QuestionParser.sql_transfer的参数entities---> ['放射性肺炎']

        '''数据库查询语句'''
        sql = []

        '''查询疾病的相关介绍'''
        if question_type == 'disease_intro':
            sql = ["MATCH (m:Disease) where m.name = '{0}' return m.name, m.intro".format(item) for item in entities]
            print("question_type:{},sql:{}".format(question_type,sql)) 


        elif question_type == 'disease_symptom': #         '''查询疾病有哪些症状'''
            sql = ["MATCH (m:Disease)-[r:has_symptom]->(n:Symptom) where m.name = '{0}' return m.name, r.name, n.name".format(item) for item in entities]
            print("question_type:{},sql:{}".format(question_type,sql)) # question_type:disease_symptom,sql:["MATCH (m:Disease)-[r:has_symptom]->(n:Symptom) where m.name = '放射性肺炎' return m.name, r.name, n.name"]

        # '''查询症状会导致哪些疾病'''
        elif question_type == 'symptom_disease':
            sql = ["MATCH (m:Disease)-[r:has_symptom]->(n:Symptom) where n.name = '{0}' return m.name, r.name, n.name".format(item) for item in entities]
            print("question_type:{},sql:{}".format(question_type,sql)) 

        # '''查询疾病的并发症'''
        elif question_type == 'disease_complication':
            sql1 = ["MATCH (m:Disease)-[r:accompany_with]->(n:Disease) where m.name = '{0}' return m.name, r.name, n.name".format(item) for item in entities]
            sql2 = ["MATCH (m:Disease)-[r:accompany_with]->(n:Disease) where n.name = '{0}' return m.name, r.name, n.name".format(item) for item in entities]
            sql = sql1 + sql2
            print("question_type:{},sql:{}".format(question_type,sql)) 
        return sql
    
    '''解析主函数'''
    # 从分类结果的{'args': {'放射性肺炎': ['disease','xx']}, 'question_types': ['disease_symptom']}  
    # 获取args，返回{'disease': ['放射性肺炎'], 'xx': ['放射性肺炎']}的形式
    def parser_main(self, question_classify):
        print("question_classify--->",question_classify) # question_classify---> {'args': {'放射性肺炎': ['disease']}, 'question_types': ['disease_symptom']}  
        args = question_classify['args']  # args的值为{'放射性肺炎': ['disease']}
        
        entity_dict = self.build_entity_dict(args)  # 调用build_entitydict函数，返回形如{'实体类型':['领域词'],...}的entity_dict字典
        print("entity_dict------->",entity_dict) # entity_dict-> {'disease': ['放射性肺炎']}
    
        question_types = question_classify['question_types']
        sqls = []
        for question_type in question_types:  # 对问句分类返回值中[‘question_types’]的每一个question_type
            sql_ = {}  # 调用sql_transfer函数转换为neo4j的Cypher语言。
            sql = []  # 最后组合每种question_type转换后的sql查询语句
            sql_['question_type'] = question_type

            # '''查询疾病的相关介绍'''
            if question_type == 'disease_intro':
                sql = self.sql_transfer(question_type, entity_dict.get('disease'))

            # '''查询疾病有哪些症状'''
            elif question_type == 'disease_symptom':
                sql = self.sql_transfer(question_type, entity_dict.get('disease'))

            # '''查询症状会导致哪些疾病'''
            elif question_type == 'symptom_disease':
                sql = self.sql_transfer(question_type, entity_dict.get('symptom'))

            # '''查询疾病的并发症'''
            elif question_type == 'disease_complication':
                sql = self.sql_transfer(question_type, entity_dict.get('disease'))

            if sql:
                sql_['sql'] = sql
            #     sql_['sql1'] = sql1
                sqls.append(sql_)

        return sqls
```

4.创建AnswerSearch类，实现对neo4j的查询。

```python
class AnswerSearch:  # 定义了Graph类的成员变量g和返回答案列举的最大个数num_list。
    # 成员函数有两个，一个查询主函数search_main一个回复模块answer_prettify
    def __init__(self):
        self.g = Graph(
            host='localhost',
            http_port='7474',
            user='neo4j',
            password='111111'
        )
        self.num_limit = 20
    '''格式化输出'''
    def answer_prettify(self, question_type, answers):
        print("answer_prettify-->question_type-->",question_type) 
        # answer_prettify-->question_type--> disease_symptom
        print("answer_prettify-->answers-->",answers) 
        # answer_prettify-->answers--> [{'m.name': '放射性肺炎', 'r.name': '症状', 'n.name': '闫铁'}, {'m.name': '放射性肺炎', 'r.name': '症状', 'n.name': '肺纤维化'}, {'m.name': '放射性肺炎', 'r.name': '症状', 'n.name': '低热'}, {'m.name': '放射性肺炎', 'r.name': '症状', 'n.name': '胸痛'}]
        final_answer = []
        # 如果问题存在，设置最终答案格式 m-前面，n-后面
        if question_type == 'disease_symptom':  # 这里就是 m-disease n-symptom
            key = [i['n.name'] for i in answers]  # key 是症状
            value = answers[0]['m.name']  # value 此时是疾病
            final_answer = '{0}的症状包括：{1}'.format(value, ','.join(list(set(key))[:self.num_limit]))
            # 最终答案为  key的症状包括: 以：分割且每个症状不多于20个词的
        elif question_type == 'symptom_disease':
            key = [i['m.name'] for i in answers]
            value = answers[0]['n.name']
            final_answer = '症状{0}可能染上的疾病有：{1}'.format(value, ','.join(list(set(key))[:self.num_limit]))

        elif question_type == 'disease_intro':
            key = [i['m.intro'] for i in answers]
            value = answers[0]['m.name']
            final_answer = '{0},熟悉一下：{1}'.format(value, ','.join(list(set(key))[:self.num_limit]))

        elif question_type == 'disease_complication':
            key1 = [i['n.name'] for i in answers]
            key2 = [i['m.name'] for i in answers]
            value = answers[0]['m.name']
            key = [i for i in key1 + key2 if i != value]
            final_answer = '{0}的并发症包括：{1}'.format(value, ','.join(list(set(key))[:self.num_limit]))

        return final_answer
    '''传入问题解析的结果sqls'''
    def search_main(self, sqls):  
        final_answers = []
        print("search_main-->sqls-->",sqls) 
        # search_main-->sqls--> [{'question_type': 'disease_symptom', 'sql': ["MATCH (m:Disease)-[r:has_symptom]->(n:Symptom) where m.name = '放射性肺炎' return m.name, r.name, n.name"]}]
        for sql_ in sqls: # 每个Cypher语句执行一次
            question_type = sql_['question_type'] # 问题类别
            queries = sql_['sql'] # 解析后的Cypher语句list
            answers = []

            for query in queries: # 遍历解析后的Cypher语句list
                res = self.g.run(query).data()  # 调用self.g.run(query).data()函数
                answers += res  # 执行['sql']中的查询语句得到查询结果

            final_answer = self.answer_prettify(question_type, answers) # 格式化结果

            if final_answer:  # 再根据['question_type']的不同调用answer_prettify函数将查询结果和答案话术结合起来。
                final_answers.append(final_answer)

        return final_answers 
'''主函数'''
if __name__ == '__main__':
    question = "放射性肺炎的症状有哪些"
    # question = "蛋白尿"
    classifier = QuestionClassifier()
    classifier  = classifier.classify(question) #对语句进行分类，结果存入classifier
    parser = QuestionParser()
    #再对sqls提取关键词
    sqls = parser.parser_main(classifier)
    # 最终答案在答案搜索文件的search_main函数可得
    searcher = AnswerSearch()
    final_answers = searcher.search_main(sqls)
    print('classifier->'+str(classifier))
    print('sqls->'+str(sqls))
    print('final_answers->',final_answers)


```

输出如下:

/home/ubuntu

init project,please wait a mins

parse\_question---> (4, (76, '放射性肺炎'))

parse\_question---> (4, (78, '肺炎'))

final\_wds-->\['放射性肺炎'\]

final\_dict-->{'放射性肺炎': \['disease'\]}

entity\_dict:---> {'放射性肺炎': \['disease'\]}

entity\_types:---> \['disease'\] {'args': {'放射性肺炎': \['disease'\]},

'question\_types': \['disease\_symptom'\]}

question\_classify---> {'args': {'放射性肺炎': \['disease'\]},

'question\_types': \['disease\_symptom'\]}

entity\_dict-------> {'disease': \['放射性肺炎'\]}

QuestionParser.sql\_transfer的参数question\_type---> disease\_symptom QuestionParser.sql\_transfer的参数entities---> \['放射性肺炎'\] question\_type:disease\_symptom,sql:\["MATCH (m:Disease)-\[r:has\_symptom\]\->(n:Symptom) where m.name = '放射性肺炎' return m.name, r.name, n.name"\]

search\_main-->sqls--> \[{'question\_type': 'disease\_symptom', 'sql': \["MATCH (m:Disease)-\[r:has\_symptom\]\->(n:Symptom) where m.name = '放射性肺炎' return m.name, r.name, n.name"\]}\]

answer\_prettify-->question\_type--> disease\_symptom answer\_prettify-->answers--> \[{'m.name': '放射性肺炎', 'r.name': '症状', 'n.name': '肺纤维化'}, {'m.name': '放射性肺炎', 'r.name': '症状', 'n.name': '低热'}, {'m.name': '放射性肺炎', 'r.name': '症状', 'n.name': '闫铁'}, {'m.name': '放射性肺炎', 'r.name': '症状', 'n.name': '胸痛'}\]

classifier->{'args': {'放射性肺炎': \['disease'\]}, 'question\_types': \['disease\_symptom'\]}

sqls->\[{'question\_type': 'disease\_symptom', 'sql': \["MATCH (m:Disease)-\[r:has\_symptom\]\->(n:Symptom) where m.name = '放射性肺炎' return m.name, r.name, n.name"\]}\]

final\_answers-> \['放射性肺炎的症状包括：胸痛,低热,闫铁,肺纤维化'\]

### 实验总结

该实验的主要内容是输入特定领域的问句，进行问句分类，问句解析，问句查询，最终从neo4j中或得相关数据。在使用过程中，可以扩展问句分类的种类，丰富实验功能。