### **实验目的**

掌握Java操作Neo4j

掌握Python操作Neo4j

### **实验背景**

Neo4j是一个高性能的NoSQL图形数据库，它将结构化数据存储在网络上而不是表中。Neo4j是一个嵌入式的、基于磁盘的、具备完全的事务特性的Java持久化引擎。Neo4j也可以被看作是一个高性能的图引擎，该引擎具有成熟数据库的所有特性。使用Neo4j时，程序员工作在一个面向对象的、灵活的网络结构下，而不是严格、静态的表中，但是他们可以享受到具备完全的事务特性、企业级的数据库的所有好处。Neo4j因其具备的嵌入式、高性能、轻量级等优势，越来越受到人们的关注。

基于Java和Python操作Neo4j数据库，可以将Neo4j整合到工程中，便于更充分的利用Neo4j数据库的特性。

### **实验原理**

neo4j-java-driver库是Java链接Neo4j的驱动，通过neo4j-java-driver提供的方法，可以很方便的操作Neo4j数据库，实现对Neo4j的增删改查等操作。

基于Python操作Neo4j可以采用官方的neo4j库，也可采用py2neo库，本案例以官方的neo4j库为例，对Neo4j进行操作，更多的Python操作Neo4j案例可参考官网手册。

### **实验环境**

Ubuntu 16.04

jdk1.8

Maven3.6.1

IDEA/Eclipse

Python3.6

jupyter

### **建议课时**

2课时

### **实验步骤**

一、开启Neo4j

在命令行下执行如下命令：

```markup
sudo neo4j start
```

启动完成后，浏览器打开

```markup
localhost:7474
```

提示输入密码，初始密码为neo4j，如下图：

![neo4j初始密码.png](./pic/neo4j初始密码.png)

初始密码输入后，需要修改密码，如下图：

![neo4j修改密码.png](./pic/neo4j修改密码.png)

修改密码完成后，如果可以看到如下图所示，则说明neo4j启动完成

![neo4j启动.png](./pic/neo4j启动.png)

二、Java操作Neo4j

1.创建Java开发环境

打开Eclipse

![打开eclipse1.png](./pic/打开eclipse1.png)

eclipse运行后，选择File--new--other

![创建eclipse工程1.png](./pic/创建eclipse工程1.png)

在other弹出中，选择一个maven工程

![创建eclipse工程2.png](./pic/创建eclipse工程2.png)

选择Next

![创建eclipse工程3.png](./pic/创建eclipse工程3.png)

选择Next

![创建eclipse工程4.png](./pic/创建eclipse工程4.png)

输入artifact Id ，名为neo4jdemo，然后选择Finish

![创建eclipse工程5.png](./pic/创建eclipse工程5.png)

创建后的maven工程如下：

![创建eclipse工程6.png](./pic/创建eclipse工程6.png)

打开pom.xml文件，添加Neo4j的Java驱动，

![pom文件添加依赖.png](./pic/pom文件添加依赖.png)

pom依赖如下：

```java
<dependency>
        <groupId>org.neo4j.driver</groupId>
       <artifactId>neo4j-java-driver</artifactId>
       <version>4.0.1</version>
 </dependency>
```

eclipse需要手动保存文件，每次修改后，都要执行ctrl+s ，手动保存。

2.创建HelloWorldExample类

依赖添加完成，在工程中创建类文件

![新建HelloWorldExample类.png](./pic/新建HelloWorldExample类.png)

类名为HelloWorldExample，选择main方法，选择Finish创建完成。

![新建HelloWorldExample类2.png](./pic/新建HelloWorldExample类2.png)

HelloWorldExample实现AutoCloseable接口：

在Java1.7之前，需要通过try{} finally{} 在finally中释放资源，在Java1.8之后，实现AutoCloseable接口的类的实例，在try结束的时候，会自动将这些资源关闭（调用close方法）。在 类名HelloWorldExample添加实现:

```markup
implements AutoCloseable
```

然后HelloWorldExample类出现红色波浪线，左键单击HelloWorldExample，选择add unimplemented methods。

![实现implements并实现方法.png](./pic/实现implements并实现方法.png)

此时类的组成为：

```java
public class HelloWorldExample implements AutoCloseable{

     public void close() throws Exception{
        // TODO Auto-generated method stub
    }   

    public static void main( String[] args ) throws Exception{
        // TODO Auto-generated method stub
    }
    
}
```

在HelloWorldExample中添加需要的依赖,并定义待实现的方法

代码如下：

```java
import org.neo4j.driver.*;

import static org.neo4j.driver.Values.parameters;
public class HelloWorldExample implements AutoCloseable{

    // 定义构造函数HelloWorldExample
    
    // 定义插入数据的方法printGreeting
    
    //定义读取方法getGreeting
        
    //定义main方法
    public static void main( String[] args ) throws Exception{
        // TODO Auto-generated method stub
    }
    
    // 定义释放资源的方法close
     public void close() throws Exception{
        // TODO Auto-generated method stub
    } 
    
}
```

完成以上步骤，如果代码没有报错，则表示依赖导入成功，下面就可以开始在HelloWorldExample中连接Neo4j数据库，并对Neo4j数据库进行操作。

3.Java操作Neo4j

定义构造方法，在初识化对象时获得Driver实例，代码如下：

```java
// 定义构造函数
private final Driver driver;
public HelloWorldExample( String uri, String user, String password )
{
  driver = GraphDatabase.driver( uri, AuthTokens.basic( user, password ) );
}
```

Driver类通过import org.neo4j.driver.Driver导入，HelloWorldExample是构造方法，表示在创建HelloWorldExample对象时，可以通过传入uri，user，password等参数，初始化一个Driver对象，并复制为driver变量。

定义自动释放资源的方法，实例会自动调用close()方法关闭带资源的try语句，代码如下：

```markup
// 定义释放资源的方法
public void close() throws Exception
{
    driver.close();
} 
```

定义向Neo4j中插入数据的方法printGreeting，代码如下：

```markup
// 定义插入数据的方法printGreeting
public void printGreeting( final String message )
{
    try ( Session session = driver.session() )
    {
        String greeting = session.writeTransaction( new TransactionWork<String>()
             {
                  @Override
                 public String execute( Transaction tx )
                 {
                     Result result = tx.run( "CREATE (a:Greeting) " +
                                            "SET a.message = $message " +
                                            "RETURN a.message + ', from node ' + id(a)",
                                            parameters( "message", message ) );

                     return result.single().get( 0 ).asString();
                 }
             } );
        System.out.println( greeting );
    }
}
```

如果出现转换JRE为1.7的提示，直接按要求选择即可

![修改JRE为1.7.png](./pic/修改JRE为1.7.png)

session会话为Cypher的执行提供了一个经典的阻塞API。在session会话的API调用，是严格按顺序执行的。

session.writeTransaction用于开启一个写事务，当事务失败时，将调用驱动程序重试逻辑。

其余的代码段用于在执行一条插入语句，创建一个Greeting类型的节点，并将该节点的message属性值设置为printGreeting方法传入的参数，插入结束后返回该节点的message属性值及id值，并输出到控制台。

定义main方法，代码如下：

```markup
//定义main方法
public static void main( String... args ) throws Exception
{
    try ( HelloWorldExample greeter = new HelloWorldExample( "bolt://localhost:7687", "neo4j", "123456" ) )
    {
        greeter.printGreeting( "hello, world" );
    }
}
```

在main方法中，实现AutoCloseable接口的HelloWorldExample类实例，位于try后面，这被称为带资源的try语句，在try结束的时候，会自动调用定义的close方法，将driver资源关闭。在实例化HelloWorldExample传入的三个参数分别为链接Neo4j的uri，数据库的用户名，密码等，读者在实验过程中，要将这三个参数值替换为自己数据库的对应值。

右键main方法，执行程序，返回结果如下：

八月 06, 2021 8:07:32 下午 org.neo4j.driver.internal.logging.JULogger info  
信息: Direct driver instance 905654280 created for server address localhost:7687  
hello, world, from node 0  
八月 06, 2021 8:07:34 下午 org.neo4j.driver.internal.logging.JULogger info  
信息: Closing driver instance 905654280  
八月 06, 2021 8:07:34 下午 org.neo4j.driver.internal.logging.JULogger info  
信息: Closing connection pool towards localhost:7687

在返回结果中可以看到，有hello, world, from node 0，其中hello，world表示节点属性，0表示节点id。这时打开Neo4j的web界面，输入

```markup
MATCH (n:Greeting) RETURN n,id(n) LIMIT 25
```

可以查看到返回值为：

│"n"            │"id(n)"│  
│{"message":"hello, world"}│0    │

再定义一个方法getGreeting(),该方法用于读取刚插入的Greeting类型的节点，并返回该节点的message属性值，代码如下：

```markup
//定义读取方法getGreeting

public String getGreeting()

{
    try ( Session session = driver.session() )
    {
        return session.readTransaction( tx -> {
            Result result = tx.run( "MATCH (a:Greeting) RETURN a.message" );
            return result.next().get( 0 ).asString();
        } );
    }
}
```

如果这时提示，需要修改jre为1.8，直接点击提示就可以

![修改JRE为1.8.png](./pic/修改JRE为1.8.png)

在main方法中，添加代码如下：

```markup
//注释掉 greeter.printGreeting( "hello, world" );
//greeter.printGreeting( "hello, world" );
//添加调用getGreeting的代码
System.out.println(greeter.getGreeting());
```

右键main方法，执行程序，返回结果如下：

八月 06, 2021 9:06:26 下午 org.neo4j.driver.internal.logging.JULogger info  
信息: Direct driver instance 905654280 created for server address localhost:7687  
hello, world  
八月 06, 2021 9:06:27 下午 org.neo4j.driver.internal.logging.JULogger info  
信息: Closing driver instance 905654280  
八月 06, 2021 9:06:27 下午 org.neo4j.driver.internal.logging.JULogger info  
信息: Closing connection pool towards localhost:7687

从返回结果可以看到插入的节点信息 hello world

三、Python操作Neo4j

1.安装neo4j库

```markup
pip install neo4j==4.0.3
```

2.打开jupyter

```markup
jupyter notebook
```

在打开的浏览器端，新建python3文件

![创建一个py文件.png](./pic/创建一个py文件.png)

导入相关依赖

```markup
from neo4j import GraphDatabase
```

3.定义HelloWorldExample类，并包含相关函数

```markup
class HelloWorldExample:

    def __init__(self, uri, user, password):
        self.driver = GraphDatabase.driver(uri, auth=(user, password))

    def close(self):
        self.driver.close()

    def print_greeting(self, message):
        with self.driver.session() as session:
            greeting = session.write_transaction(self._create_and_return_greeting, message)
            print(greeting)

    @staticmethod
    def _create_and_return_greeting(tx, message):
        result = tx.run("CREATE (a:PythonGreeting) "
                        "SET a.message = $message "
                        "RETURN a.message + ', from node ' + id(a)", message=message)
        return result.single()[0]
```

其中class HelloWorldExampl表示定义了一个类；

def \_\_init\_\_()函数为类初始化函数，在构建类对象时，会在初识化函数中构建一个driver变量；

def close()函数用于关闭driver；

print\_greeting()函数中，先构建一个session会话，并在session会话中开启一个事务，调用\_create\_and\_return\_greeting()静态方法，传入message参数，并输出返回结果。

\_create\_and\_return\_greeting()用于创建一个PythonGreeting类型的节点，并将该节点的message属性值设置为printGreeting方法传入的参数，插入结束后返回该节点的message属性值及id值。

初始化HelloWorldExample，调用并执行print\_greeting函数，执行后调用close关闭资源，具体代码如下：

```markup
if __name__ == "__main__":
  greeter = HelloWorldExample("bolt://localhost:7687", "neo4j", "123456")
  greeter.print_greeting("hello, world")
  greeter.close()
```

返回值为：

hello, world, from node 65

在返回结果中可以看到，有hello, world, from node 65，其中“hello，world”表示节点属性，65表示节点id。这时打开Neo4j的web界面，输入

```markup
MATCH (n:PythonGreeting) RETURN n,id(n) LIMIT 25
```

可以查看到返回值为：

│"n"            │"id(n)"│  
​  
│{"message":"hello, world"}│65   │

### **实验总结**

本实验的主要内容是基于Java和Python实现了Neo4j的插入和读取操作，经过本实验，可以快速将Neo4j整合到工程项目中。更多操作，读者可以根据官网进行拓展。