### **实验目的**

掌握Neo4j数据的备份与恢复

掌握Neo4j的性能监控

掌握Neo4j用户安全

### **实验背景**

Neo4j社区版仅支持离线备份，在线备份是企业版支持的功能。数据库运维在小企业还是大企业都有着重要的意义，如果数据库出现问题，很容易导致整个业务系统出现问题，本实验提供一些基本的运维命令，辅助读者掌握Neo4j的基本运维使用。

### **实验原理**

Neo4j运维功能与关系型数据库运维基本类似，运维命令为Neo4j数据库自带命令，本实验主要基于Neo4j的离线备份与恢复实现，需要注意的是，在运行转储和恢复命令之前，应该关闭数据库。

### **实验环境**

Ubuntu 16.04

jdk1.8

Neo4j3.5.5

### **建议课时**

1课时

### **实验步骤**

一、开启Neo4j

在命令行下执行如下命令：

```markup
sudo neo4j start

```

启动完成后，浏览器打开

```markup
localhost:7474

```

提示输入密码，初始密码为neo4j，如下图：

![neo4j初始密码.png](./pic/neo4j初始密码.png)

初始密码输入后，需要修改密码，如下图：

![neo4j修改密码.png](./pic/neo4j修改密码.png)

修改密码完成后，如果可以看到如下图所示，则说明neo4j启动完成

![neo4j启动.png](./pic/neo4j启动.png)

生成示例数据

```markup
CREATE (ee:Person { name: "Emil", from: "Sweden", klout: 99})

```

二、Neo4j备份与恢复

1.备份Neo4j数据库文件

进入到当前用户主目录:

```markup
cd ~

```

创建备份目录:

```markup
mkdir ~/backups

```

备份当前数据库文件：

```markup
sudo neo4j stop 
sudo neo4j-admin dump --database=graph.db --to=backups/neo4j-`date "+%Y_%m_%d"`.dump 

```

基于neo4j-admin dump可完成数据库备份，其中--database为要备份的数据库，--to为备份数据库的文件路径。输出如下：

![](pic/Snipaste_2023-11-25_10-59-47.jpg)

查看生成的数据库备份文件：

```markup
cd ~
pwd


```

输出为

/home/ubuntu

```markup
ls backups/


```

输出为



![](pic/Snipaste_2023-11-25_11-00-41.jpg)

neo4j-2023\_11_25.dump就是生成的数据库转储备份数据。

2.恢复Neo4j数据库

进入到当前用户主目录：

```markup
cd ~

```

执行恢复数据库命令：

```markup
sudo neo4j stop 
sudo neo4j-admin load --from=backups/neo4j-`date "+%Y_%m_%d"`.dump --database=graph.db --force 
sudo neo4j start

```

基于neo4j-admin load可完成数据库恢复，加载备份的数据库文件，当使用--force选项时，会覆盖现有的。

三、Neo4j性能与安全

1.Neo4j运行情况

在浏览器Cypher执行窗口输入：

```markup
:sysinfo

```

可返回Neo4j的运行状况，返回如下图所示：

![neo4j运行状况.jpg](./pic/neo4j运行状况.jpg)

在返回结果可以发现，Neo4j的运行情况主要分为4个方面：Store Sizes（存储容量）、ID Allocation（ID分配）、Page Cache（页面缓存）、Transactions（事务）。下面分别对这四个部分的部分指标进行描述。

Store Sizes（存储容量）表示Neo4j数据库中存储文件的大小，比如Node Store表示节点存储容量大小，Relationship Store表示关系存储容量大小，其余含义与英文命名基本一致，不再一一描述。

ID Allocation（ID分配）表示ID分配情况，其中Node ID表示节点总数，Property ID 表示不同属性名称数量，Relationship ID表示关系总数，Relationship Type ID关系类型的数量。

Page Cache（页面缓存）表示页面缓存的情况，其中Bytes Read表示页面缓存读入字节数，Bytes Written表示页面缓存写入字节数，Flushes表示页面缓存执行的刷新次数。

Transactions（事务）表示事务的相关信息，其中Last Tx Id 表示最后提交事务的ID，Current表示当前活动事务的数量，peak表示事务并发的最大值，Opened表示启动事务的数量，Committed表示提交事务的数量

Neo4j企业版支持将Neo4j指标导出到外部文件，日志查看等高级运维功能，如果使用Neo4j企业版，查看企业版的相关文档即可。

2.获取Neo4j的用户权限信息

1)获取所有用户列表。

在浏览器端输入：

```markup
CALL dbms.security.listUsers()

```

返回值为：

![](pic/Snipaste_2023-11-25_11-02-20.jpg)



其中username表示存在的用户，falgs表示该用户是否需要修改密码。

2)新增用户。

在浏览器端输入新增用户tempname命令（该用户首次登陆需要修改密码）：

```markup
CALL dbms.security.createUser('tempname','123456',true)

```

再次输入新增用户命令（该用户首次登录不需要修改密码）：

```markup
CALL dbms.security.createUser('tempname1','123456',false)

```

其中'tempname'表示新创建的用户名，'123456'表示用户密码，true表示该用户首次登录需要修改密码。

在浏览器端输入：

```markup
CALL dbms.security.listUsers()

```

返回值为：

![](pic/Snipaste_2023-11-25_11-03-09.jpg)



其中password\_change\_required表示对应用户首次登录密码需要修改。

3)删除用户。

在浏览器端输入删除用户命令：

```markup
CALL dbms.security.deleteUser('tempname1')

```

其中'tempname1'表示要删除的用户名，如果删除的用户名不存在，或待删除的用户名为当前用户，会抛出异常，并回滚当前事务。

在浏览器端输入：

```markup
CALL dbms.security.listUsers()

```

返回值为：

![](pic/Snipaste_2023-11-25_11-04-30.jpg)



4)查看当前用户。

在浏览器端输入查看当前用户命令：

```markup
CALL dbms.security.showCurrentUser()

```

返回值为当前用户，返回值为：

![](pic/Snipaste_2023-11-25_11-05-18.jpg)



5)修改当前用户密码。

在浏览器端输入修改当前用户密码命令：

```markup
CALL dbms.security.changePassword("1234567")

```

即可当前neo4j用户的密码修改为“1234567”。如果刷新页面，或重新打开localhost:7474，输入修改后的密码即可

### **实验总结**

本实验主要完成了Neo4j的备份与恢复，性能查看与安全设置等操作，在使用过程中可以结合需求，参考官网实现更多的运维练习。