# 名片管理类
class CardManager(object):
    def __init__(self):
        # 存储名片数据 -- 列表
        self.card_list = []

    # 一. 程序入口方法
    def run(self):
        # 1. 定义一个while循环
        while True:
            # 2. 显示功能菜单
            self.show_menu()
            # 3. 用户输入目标功能序号
            menu_num = int(input('请输入您需要的功能序号：'))
            # 4. 根据用户输入的序号执行不同的功能 -- 如果用户输入1，执行添加
            if menu_num == 1:
                # 添加名片
                self.add_card()
            elif menu_num == 2:
                # 删除名片
                self.del_card()
            elif menu_num == 3:
                # 修改名片信息
                self.modify_card()
            elif menu_num == 4:
                # 查询名片信息
                self.search_card()
            elif menu_num == 5:
                # 显示所有名片信息
                self.show_card()
            elif menu_num == 0:
                # 退出系统 -- 退出循环
                break

    # 二. 系统功能函数
    # 2.1 显示功能菜单 -- 打印序号的功能对应关系 -- 静态
    @staticmethod
    def show_menu():
        print("**"*30)
        print("欢迎使用【名片管理系统】V2.0")
        print('请选择如下功能：')
        print()
        print('1:添加名片')
        print('2:删除名片')
        print('3:修改名片信息')
        print('4:查询名片信息')
        print('5:显示所有名片信息')
        print()
        print('0:退出系统')
        print("**" * 30)

    # 2.2 添加名片
    def add_card(self):
        # 1. 用户输入姓名、性别、手机号
        name = input('请输入您的姓名：')
        gender = input('请输入您的性别：')
        tel = input('请输入您的手机号：')

        # 2. 创建名片对象 -- 类
        card = Card(name, gender, tel)
        # 3. 将该对象添加到名片列表
        self.card_list.append(card)
        # print(card)

    # 2.3 删除名片
    def del_card(self):
        # 1. 用户输入目标名片姓名
        del_name = input('请输入要删除的名片姓名：')

        # 2. 遍历名片列表，如果用户输入的名片存在则删除名片对象，否则提示名片不存在
        for i in self.card_list:
            if del_name == i.name:
                # 删除该名片对象
                self.card_list.remove(i)
                print('删除成功！')
                break
        else:
            # 循环正常价结束执行的代码：循环结束都没有删除任何一个对象，所以说明用户输入的目标名片不存在
            print('查无此人！')

    # 2.4 修改名片信息
    def modify_card(self):
        # 1. 用户输入目标名片姓名
        modify_name = input('请输入要修改的名片姓名：')

        # 2. 遍历列表数据，如果名片存在修改姓名性别手机号，否则提示名片不存在
        for i in self.card_list:
            if modify_name == i.name:
                i.name = input('姓名：')
                i.gender = input('性别：')
                i.tel = input('手机号：')
                print(f'修改名片信息成功，姓名{i.name}, 性别{i.gender}, 手机号{i.tel}')
                break
        else:
            print('查无此人！')

    # 2.5 查询名片信息
    def search_card(self):
        # 1. 用户输入目标名片姓名
        search_name = input('请输入您要搜索的名片姓名：')

        # 2. 遍历列表。如果名片存在打印名片信息，否则提示名片不存在
        for i in self.card_list:
            if search_name == i.name:
                print(f'姓名是{i.name}, 性别是{i.gender}, 手机号是{i.tel}')
                break
        else:
            print('查无此人！')

    # 2.6 显示所有名片信息
    def show_card(self):
        # 1. 打印表头
        print('姓名\t性别\t手机号')

        # 2. 打印名片数据
        for i in self.card_list:
            print(f'{i.name}\t{i.gender}\t{i.tel}')

# 名片类
class Card(object):
    def __init__(self, name, gender, tel):
        # 姓名、性别、手机号
        self.name = name
        self.gender = gender
        self.tel = tel

# 创建主函数并启动管理系统
if __name__ == '__main__':
    card_manager = CardManager()
    card_manager.run()
