/*************************************************************************************************************

: 			U1ӰͨS5ʶƬE1ʾɶIDд

*************************************************************************************************************/



#include "gd32f4xx.h"

#include "gd32f450z_eval.h"

#include "main.h"

#include "i2c.h" // I2Cͨصͷļ

#include "e1.h"  // E1Ӱƺͷļ

#include "s5.h"



uint16_t half_count = 0;    // 

uint16_t time_count = 0;    // ʱ

uint16_t min_count = 0;     //1sʱ

uint8_t  second_flag = 0;   // ־

uint8_t  minflag = 0;

uint8_t  dis_number = 0;    // ʾֱ

uint16_t delay_count = 0;   // ʱ

uint8_t Cardnum[20] = {0};

uint8_t status = 0;



i2c_addr_def e1_ht16k33_addr; // E1ӰLEDַ

i2c_addr_def s5_addr;

uint8_t key1[6] = {0x00,0x00,0x00,0x00,0x00,0x00};

uint8_t key2[6] = {0xFF,0xFF,0xFF,0xFF,0xFF,0xFF};

int block_addr = 8; // дĿַ





int main(void)

{

	  nvic_priority_group_set(NVIC_PRIGROUP_PRE4_SUB0);// NVICжϷȼ



	  timer3_init();// ʼʱ3

	  init_i2c(); // ʼI2Cͨ

 

		while(!second_flag){}; // 1sӳ
		
	  e1_ht16k33_addr = e1_init(HT16K33_ADDRESS_E1);// ʼE1Ӱ

	  s5_addr = s5_init(MS523_ADDRESS_S5);          // ʼs5-NFCӰ
	
		status = s5_detect(s5_addr.periph, s5_addr.addr, Cardnum); // IDⲢȡ
			
		// ʾ
		e1_digital_display(e1_ht16k33_addr.periph, e1_ht16k33_addr.addr,(Cardnum[0] >> 4) & 0xF,Cardnum[0] & 0xF,(Cardnum[1] >> 4) & 0xF,Cardnum[1] & 0xF);
		
		
		while(!second_flag){};
			
		// дʱ䣺Сʱ+
		uint8_t time[4] = {1, 6, 1, 8};
		
		// дʱtime
		write_time(s5_addr.periph, s5_addr.addr, time);
		
		e1_digital_display(e1_ht16k33_addr.periph, e1_ht16k33_addr.addr,0,0,0,0);

}



void write_time(uint32_t periph,uint32_t addr,uint8_t *time)

{
	
	uint8_t data[16] = {0};
	
	uint8_t rt = 0;
	
	for(int i=0;i<4;i++)
	{
		data[i] = time[i];
	}
	
	if(!s5_verify(periph, addr, PICC_AUTHENT1A, block_addr, key1, Cardnum))
	{
		
		rt = s5_write_data(periph, addr, block_addr, data);
	
	}
	else
	{
		if(!s5_verify(periph, addr, PICC_AUTHENT1A, block_addr, key2, Cardnum))
		{rt = s5_write_data(periph, addr, block_addr, data);}
	
	}
	
}

void read_time(uint32_t periph,uint32_t addr,uint8_t *time)
	
{
	
	uint8_t data[16] = {0};
	
	uint8_t rt = 0;
	
	if(!s5_verify(periph, addr, PICC_AUTHENT1A, block_addr, key1, Cardnum))
	{
		
		rt = s5_read_data(periph, addr , block_addr, data);
		
		for(int i=0;i<4;i++)
		{
			time[i] = data[i];
		}
	
	}
	else
	{
		if(!s5_verify(periph, addr, PICC_AUTHENT1A, block_addr, key2, Cardnum))
		{
		
			rt = s5_read_data(periph, addr , block_addr, data);
			
			for(int i=0;i<4;i++)
			{
				time[i] = data[i];
			}
	
		}
	
	}

}




/***********************************************************************************************************

//timer3 init 1msʱ

************************************************************************************************************/

void timer3_init(void)

{

		timer_parameter_struct timer_init_struct;

		

		rcu_periph_clock_enable(RCU_TIMER3);

		

		timer_deinit(TIMER3);

		timer_init_struct.prescaler			= 4199;	

		timer_init_struct.period			= 20;

		timer_init_struct.alignedmode		= TIMER_COUNTER_EDGE;

		timer_init_struct.counterdirection	= TIMER_COUNTER_UP;

		timer_init_struct.clockdivision		= TIMER_CKDIV_DIV1;

		timer_init_struct.repetitioncounter = 0;				

		timer_init(TIMER3, &timer_init_struct);

		

		nvic_irq_enable(TIMER3_IRQn, 1, 1); 

		timer_interrupt_enable(TIMER3, TIMER_INT_UP);

		timer_enable(TIMER3);

	

		

}









/********************************************************************************************************

ʱms

*********************************************************************************************************/

void delay_ms(uint16_t mstime)

{

     delay_count = mstime;

     while(delay_count)

		 {

		 }	  

}

/********************************************************************************************************

1msʱжϷ

*********************************************************************************************************/

void TIMER3_IRQHandler(void)

{

		if(timer_interrupt_flag_get(TIMER3, TIMER_INT_FLAG_UP))

		{

			   timer_interrupt_flag_clear(TIMER3, TIMER_INT_FLAG_UP);

			

			   if(delay_count > 0)

				 delay_count--;	 



         if(time_count++ >= 1000)

         {

					    time_count = 0;

					    second_flag = !second_flag;

         }					 

		}

}















